/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Label pixels that are connected to a seed and lie within a neighborhood.


NeighborhoodConnectedImageFilter labels pixels with ReplaceValue that are connected to an initial Seed
AND whose neighbors all lie within a Lower and Upper threshold range.
See:
 itk::simple::NeighborhoodConnected for the procedural interface

 itk::NeighborhoodConnectedImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkNeighborhoodConnectedImageFilter.h
*/
public class NeighborhoodConnectedImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected NeighborhoodConnectedImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.NeighborhoodConnectedImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(NeighborhoodConnectedImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(NeighborhoodConnectedImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::NeighborhoodConnectedImageFilter::~NeighborhoodConnectedImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_NeighborhoodConnectedImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::NeighborhoodConnectedImageFilter::NeighborhoodConnectedImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  NeighborhoodConnectedImageFilter() {
    this(SimpleITKJNI.new_NeighborhoodConnectedImageFilter(), true);
  }

  /**
Self&amp; itk::simple::NeighborhoodConnectedImageFilter::SetSeedList(std::vector&lt; std::vector&lt; unsigned int &gt; &gt; SeedList)

Set list of image indexes for seeds.

*/
public  void setSeedList(VectorUIntList SeedList) {
    SimpleITKJNI.NeighborhoodConnectedImageFilter_setSeedList(swigCPtr, this, VectorUIntList.getCPtr(SeedList), SeedList);
  }

  /**
std::vector&lt; std::vector&lt; unsigned int &gt; &gt; itk::simple::NeighborhoodConnectedImageFilter::GetSeedList() const

Get list of seeds.

*/
public  VectorUIntList getSeedList() {
    return new VectorUIntList(SimpleITKJNI.NeighborhoodConnectedImageFilter_getSeedList(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::NeighborhoodConnectedImageFilter::AddSeed(std::vector&lt; unsigned int &gt; point)

Add SeedList point.

*/
public  void addSeed(VectorUInt32 point) {
    SimpleITKJNI.NeighborhoodConnectedImageFilter_addSeed(swigCPtr, this, VectorUInt32.getCPtr(point), point);
  }

  /**
Self&amp; itk::simple::NeighborhoodConnectedImageFilter::ClearSeeds()

Remove all SeedList points.

*/
public  void clearSeeds() {
    SimpleITKJNI.NeighborhoodConnectedImageFilter_clearSeeds(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::NeighborhoodConnectedImageFilter::SetLower(double Lower)

Set/Get the lower threshold. The default is 0.

*/
public  void setLower(double Lower) {
    SimpleITKJNI.NeighborhoodConnectedImageFilter_setLower(swigCPtr, this, Lower);
  }

  /**
double itk::simple::NeighborhoodConnectedImageFilter::GetLower() const

Set/Get the lower threshold. The default is 0.

*/
public  double getLower() {
    return SimpleITKJNI.NeighborhoodConnectedImageFilter_getLower(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::NeighborhoodConnectedImageFilter::SetUpper(double Upper)

Set/Get the upper threshold. The default is the largest possible value
for the InputPixelType.

*/
public  void setUpper(double Upper) {
    SimpleITKJNI.NeighborhoodConnectedImageFilter_setUpper(swigCPtr, this, Upper);
  }

  /**
double itk::simple::NeighborhoodConnectedImageFilter::GetUpper() const

Set/Get the upper threshold. The default is the largest possible value
for the InputPixelType.

*/
public  double getUpper() {
    return SimpleITKJNI.NeighborhoodConnectedImageFilter_getUpper(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::NeighborhoodConnectedImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public  void setRadius(VectorUInt32 Radius) {
    SimpleITKJNI.NeighborhoodConnectedImageFilter_setRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(Radius), Radius);
  }

  /**
Self&amp; itk::simple::NeighborhoodConnectedImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public  void setRadius(long value) {
    SimpleITKJNI.NeighborhoodConnectedImageFilter_setRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::NeighborhoodConnectedImageFilter::GetRadius() const

Get the radius of the neighborhood used to compute the median

*/
public  VectorUInt32 getRadius() {
    return new VectorUInt32(SimpleITKJNI.NeighborhoodConnectedImageFilter_getRadius(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::NeighborhoodConnectedImageFilter::SetReplaceValue(double ReplaceValue)

Set/Get value to replace thresholded pixels. Pixels that lie * within
Lower and Upper (inclusive) will be replaced with this value. The
default is 1.

*/
public  void setReplaceValue(double ReplaceValue) {
    SimpleITKJNI.NeighborhoodConnectedImageFilter_setReplaceValue(swigCPtr, this, ReplaceValue);
  }

  /**
double itk::simple::NeighborhoodConnectedImageFilter::GetReplaceValue() const

Set/Get value to replace thresholded pixels. Pixels that lie * within
Lower and Upper (inclusive) will be replaced with this value. The
default is 1.

*/
public  double getReplaceValue() {
    return SimpleITKJNI.NeighborhoodConnectedImageFilter_getReplaceValue(swigCPtr, this);
  }

  /**
std::string itk::simple::NeighborhoodConnectedImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.NeighborhoodConnectedImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::NeighborhoodConnectedImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.NeighborhoodConnectedImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::NeighborhoodConnectedImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.NeighborhoodConnectedImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
