/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.view.swing.map.outline.NodeButton;
import org.freeplane.view.swing.map.outline.OutlineActions;
import org.freeplane.view.swing.map.outline.OutlineController;
import org.freeplane.view.swing.map.outline.OutlineGeometry;
import org.freeplane.view.swing.map.outline.OutlineSelection;
import org.freeplane.view.swing.map.outline.OutlineSelectionBridge;
import org.freeplane.view.swing.map.outline.RightToLeftLayout;
import org.freeplane.view.swing.map.outline.SelectionPainter;
import org.freeplane.view.swing.map.outline.TimeDelayedOutlineSelection;
import org.freeplane.view.swing.map.outline.TreeNode;

class BreadcrumbPanel
extends JPanel {
    public static final int BREADCRUMB_BOTTOM_MARGIN = (int)(UITools.FONT_SCALE_FACTOR * 4.0f);
    private static final BasicStroke BOTTOM_LINE_STROKE = new BasicStroke(BREADCRUMB_BOTTOM_MARGIN, 1, 2, 1.0f, new float[]{BREADCRUMB_BOTTOM_MARGIN, 2 * BREADCRUMB_BOTTOM_MARGIN}, 0.0f);
    private OutlineController controller;
    private OutlineSelection selection;
    private int preferredBreadcrumbHeight = 0;
    private List<TreeNode> currentBreadcrumbNodes = new ArrayList<TreeNode>();
    private OutlineSelectionBridge selectionBridge;
    private Supplier<Color> backgroundColorSupplier;

    BreadcrumbPanel() {
        this.setLayout(null);
        this.setOpaque(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                TimeDelayedOutlineSelection.outlineSelector.handleMouseEvent(e);
            }
        });
    }

    @Override
    public Color getBackground() {
        Color suppliedColor;
        if (this.backgroundColorSupplier != null && (suppliedColor = this.backgroundColorSupplier.get()) != null) {
            return suppliedColor;
        }
        return super.getBackground();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        int oldWidth = this.getWidth();
        RightToLeftLayout.onContainerWidthChange(this, oldWidth, width);
        super.setBounds(x, y, width, height);
    }

    void setBackgroundColorSupplier(Supplier<Color> backgroundColorSupplier) {
        this.backgroundColorSupplier = backgroundColorSupplier;
    }

    void initialize(OutlineController controller, OutlineSelection selection) {
        this.controller = controller;
        this.selection = selection;
        this.setupKeyBindings();
    }

    private void setupKeyBindings() {
        new OutlineActions(() -> this.controller).installOn(this, 1);
    }

    void update(List<TreeNode> breadcrumbNodes, boolean wasGeometryUpdated) {
        int breadcrumbNodeCount = breadcrumbNodes.size();
        int lastIndex = breadcrumbNodeCount - 1;
        if (wasGeometryUpdated || this.currentBreadcrumbNodes.size() != breadcrumbNodeCount || !breadcrumbNodes.isEmpty() && breadcrumbNodes.get(lastIndex) != this.currentBreadcrumbNodes.get(lastIndex)) {
            this.preferredBreadcrumbHeight = this.preferredBreadCrumbHeight(breadcrumbNodeCount);
            this.currentBreadcrumbNodes = breadcrumbNodes;
            this.controller.setBreadcrumbHeight(this.preferredBreadcrumbHeight);
            this.updateNodeButtons();
        }
    }

    int preferredBreadCrumbHeight(int breadcrumbNodeCount) {
        return OutlineGeometry.getInstance().rowHeight * breadcrumbNodeCount + BREADCRUMB_BOTTOM_MARGIN;
    }

    void updateNodeButtons() {
        this.removeAll();
        ResourceController resourceController = ResourceController.getResourceController();
        boolean useColoredOutlineItems = resourceController.getBooleanProperty("useColoredOutlineItems", false);
        int rowHeight = this.controller.getRowHeight();
        int i = 0;
        while (i < this.currentBreadcrumbNodes.size()) {
            final TreeNode node = this.currentBreadcrumbNodes.get(i);
            int y = i * rowHeight;
            int x = this.controller.calcTextButtonX(i);
            NodeButton breadcrumbButton = new NodeButton(node, useColoredOutlineItems, false, 3, OutlineGeometry.getInstance().outlineTextOrientation);
            breadcrumbButton.setBounds(x, y, breadcrumbButton.getPreferredSize().width, rowHeight);
            final TreeNode nodeToSelect = node;
            final int rowIndex = i++;
            AbstractAction selectAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (nodeToSelect.getParent() != null || nodeToSelect.getLevel() == 0) {
                        BreadcrumbPanel.this.controller.selectNode(nodeToSelect, true);
                    }
                    if (BreadcrumbPanel.this.selectionBridge != null) {
                        BreadcrumbPanel.this.selectionBridge.selectMapNodeById(nodeToSelect.getId());
                    }
                }
            };
            breadcrumbButton.addActionListener(selectAction);
            InputMap im = breadcrumbButton.getInputMap(0);
            ActionMap am = breadcrumbButton.getActionMap();
            im.put(KeyStroke.getKeyStroke("ENTER"), "selectMapNode");
            am.put("selectMapNode", selectAction);
            im.put(KeyStroke.getKeyStroke("SPACE"), "toggleExpand");
            am.put("toggleExpand", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BreadcrumbPanel.this.controller.toggleBreadcrumbNodeExpansion(nodeToSelect);
                }
            });
            breadcrumbButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    BreadcrumbPanel.this.showNavigationButtonsForBreadcrumb(nodeToSelect, rowIndex);
                    if (node.getLevel() != -1) {
                        TimeDelayedOutlineSelection.outlineSelector.handleMouseEvent(e);
                    }
                }
            });
            this.add(breadcrumbButton);
        }
        RightToLeftLayout.applyToContainer(this);
        this.revalidate();
        this.repaint();
    }

    int getPreferredBreadcrumbHeight() {
        return this.preferredBreadcrumbHeight;
    }

    List<TreeNode> getCurrentBreadcrumbNodes() {
        return new ArrayList<TreeNode>(this.currentBreadcrumbNodes);
    }

    int getCurrentBreadcrumbNodeCount() {
        return this.currentBreadcrumbNodes.size();
    }

    void setSelectionBridge(OutlineSelectionBridge bridge) {
        this.selectionBridge = bridge;
    }

    private void showNavigationButtonsForBreadcrumb(TreeNode node, int rowIndex) {
        if (node.getChildren().isEmpty()) {
            return;
        }
        this.controller.showNavigationButtonsForBreadcrumb(node, rowIndex);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.preferredBreadcrumbHeight > 0) {
            g.setColor(UITools.getDisabledTextColorForBackground(this.getBackground()));
            int y = this.preferredBreadcrumbHeight - BREADCRUMB_BOTTOM_MARGIN / 2;
            Graphics2D g2 = (Graphics2D)g;
            Stroke stroke = g2.getStroke();
            g2.setStroke(BOTTOM_LINE_STROKE);
            g.drawLine(0, y, this.getWidth(), y);
            g2.setStroke(stroke);
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        SelectionPainter.paintForBreadcrumbPanel(this, this.controller, this.selection, g);
    }
}

