import { __exports as ConvertAnsi } from '../../../../../../../_virtual/ConvertAnsi.js';
import { __require as requireAnsiRegex } from '../../../../../../ansi-regex/index.js';
import { __require as requireAnsiStyles } from '../../../ansi-styles/index.js';

var hasRequiredConvertAnsi;

function requireConvertAnsi () {
	if (hasRequiredConvertAnsi) return ConvertAnsi;
	hasRequiredConvertAnsi = 1;

	Object.defineProperty(ConvertAnsi, '__esModule', {
	  value: true
	});
	ConvertAnsi.test = ConvertAnsi.serialize = ConvertAnsi.default = undefined;

	var _ansiRegex = _interopRequireDefault(requireAnsiRegex());

	var _ansiStyles = _interopRequireDefault(requireAnsiStyles());

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : {default: obj};
	}

	/**
	 * Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
	 *
	 * This source code is licensed under the MIT license found in the
	 * LICENSE file in the root directory of this source tree.
	 */
	const toHumanReadableAnsi = text =>
	  text.replace((0, _ansiRegex.default)(), match => {
	    switch (match) {
	      case _ansiStyles.default.red.close:
	      case _ansiStyles.default.green.close:
	      case _ansiStyles.default.cyan.close:
	      case _ansiStyles.default.gray.close:
	      case _ansiStyles.default.white.close:
	      case _ansiStyles.default.yellow.close:
	      case _ansiStyles.default.bgRed.close:
	      case _ansiStyles.default.bgGreen.close:
	      case _ansiStyles.default.bgYellow.close:
	      case _ansiStyles.default.inverse.close:
	      case _ansiStyles.default.dim.close:
	      case _ansiStyles.default.bold.close:
	      case _ansiStyles.default.reset.open:
	      case _ansiStyles.default.reset.close:
	        return '</>';

	      case _ansiStyles.default.red.open:
	        return '<red>';

	      case _ansiStyles.default.green.open:
	        return '<green>';

	      case _ansiStyles.default.cyan.open:
	        return '<cyan>';

	      case _ansiStyles.default.gray.open:
	        return '<gray>';

	      case _ansiStyles.default.white.open:
	        return '<white>';

	      case _ansiStyles.default.yellow.open:
	        return '<yellow>';

	      case _ansiStyles.default.bgRed.open:
	        return '<bgRed>';

	      case _ansiStyles.default.bgGreen.open:
	        return '<bgGreen>';

	      case _ansiStyles.default.bgYellow.open:
	        return '<bgYellow>';

	      case _ansiStyles.default.inverse.open:
	        return '<inverse>';

	      case _ansiStyles.default.dim.open:
	        return '<dim>';

	      case _ansiStyles.default.bold.open:
	        return '<bold>';

	      default:
	        return '';
	    }
	  });

	const test = val =>
	  typeof val === 'string' && !!val.match((0, _ansiRegex.default)());

	ConvertAnsi.test = test;

	const serialize = (val, config, indentation, depth, refs, printer) =>
	  printer(toHumanReadableAnsi(val), config, indentation, depth, refs);

	ConvertAnsi.serialize = serialize;
	const plugin = {
	  serialize,
	  test
	};
	var _default = plugin;
	ConvertAnsi.default = _default;
	return ConvertAnsi;
}

export { requireConvertAnsi as __require };
//# sourceMappingURL=ConvertAnsi.js.map
