/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning.time;

import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.utils.binning.time.TimeUnitConfig;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.PPLBuiltinOperators;
import org.opensearch.sql.expression.function.PPLFuncImpTable;

public class AlignmentHandler {
    public static RexNode createEpochAlignedSpan(RexNode fieldExpr, int intervalValue, TimeUnitConfig config, long referenceEpochSeconds, CalcitePlanContext context) {
        RexNode epochSeconds = context.rexBuilder.makeCall(PPLBuiltinOperators.UNIX_TIMESTAMP, new RexNode[]{fieldExpr});
        RexLiteral referenceTimestamp = context.relBuilder.literal(referenceEpochSeconds);
        long intervalSeconds = config.toSeconds(intervalValue);
        RexLiteral intervalLiteral = context.relBuilder.literal(intervalSeconds);
        RexNode timeOffset = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.SUBTRACT, new RexNode[]{epochSeconds, referenceTimestamp});
        RexNode binNumber = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.FLOOR, new RexNode[]{PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.DIVIDE, new RexNode[]{timeOffset, intervalLiteral})});
        RexNode binOffset = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.MULTIPLY, new RexNode[]{binNumber, intervalLiteral});
        RexNode binStartSeconds = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.ADD, new RexNode[]{referenceTimestamp, binOffset});
        return context.rexBuilder.makeCall(PPLBuiltinOperators.FROM_UNIXTIME, new RexNode[]{binStartSeconds});
    }

    public static RexNode createTimeModifierAlignedSpan(RexNode fieldExpr, int intervalValue, TimeUnitConfig config, String timeModifier, CalcitePlanContext context) {
        RexNode epochSeconds = context.rexBuilder.makeCall(PPLBuiltinOperators.UNIX_TIMESTAMP, new RexNode[]{fieldExpr});
        long offsetMillis = AlignmentHandler.parseTimeModifier(timeModifier);
        boolean alignToDay = timeModifier != null && timeModifier.startsWith("@d");
        long intervalSeconds = config.toSeconds(intervalValue);
        RexLiteral intervalLiteral = context.relBuilder.literal(intervalSeconds);
        if (alignToDay) {
            RexNode alignmentReference;
            RexLiteral secondsPerDay = context.relBuilder.literal(86400L);
            RexLiteral earliestTimestamp = context.relBuilder.literal(1753661723L);
            RexNode daysSinceEpoch = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.FLOOR, new RexNode[]{PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.DIVIDE, new RexNode[]{earliestTimestamp, secondsPerDay})});
            RexNode startOfEarliestDay = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.MULTIPLY, new RexNode[]{daysSinceEpoch, secondsPerDay});
            if (offsetMillis != 0L) {
                long offsetSeconds = offsetMillis / 1000L;
                alignmentReference = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.ADD, new RexNode[]{startOfEarliestDay, context.relBuilder.literal(offsetSeconds)});
            } else {
                alignmentReference = startOfEarliestDay;
            }
            RexNode timeOffset = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.SUBTRACT, epochSeconds, alignmentReference);
            RexNode binNumber = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.FLOOR, new RexNode[]{PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.DIVIDE, new RexNode[]{timeOffset, intervalLiteral})});
            RexNode binOffset = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.MULTIPLY, new RexNode[]{binNumber, intervalLiteral});
            RexNode binStartSeconds = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.ADD, alignmentReference, binOffset);
            return context.rexBuilder.makeCall(PPLBuiltinOperators.FROM_UNIXTIME, new RexNode[]{binStartSeconds});
        }
        RexNode divided = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.DIVIDE, new RexNode[]{epochSeconds, intervalLiteral});
        RexNode binNumber = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.FLOOR, new RexNode[]{divided});
        RexNode binStartSeconds = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.MULTIPLY, new RexNode[]{binNumber, intervalLiteral});
        return context.rexBuilder.makeCall(PPLBuiltinOperators.FROM_UNIXTIME, new RexNode[]{binStartSeconds});
    }

    private static long parseTimeModifier(String timeModifier) {
        if (timeModifier == null || timeModifier.equals("@d")) {
            return 0L;
        }
        if (timeModifier.startsWith("@d+")) {
            String offsetStr = timeModifier.substring(3);
            return AlignmentHandler.parseTimeOffset(offsetStr);
        }
        if (timeModifier.startsWith("@d-")) {
            String offsetStr = timeModifier.substring(3);
            return -AlignmentHandler.parseTimeOffset(offsetStr);
        }
        return 0L;
    }

    private static long parseTimeOffset(String offsetStr) {
        if ((offsetStr = offsetStr.trim().toLowerCase()).endsWith("h")) {
            int hours = Integer.parseInt(offsetStr.substring(0, offsetStr.length() - 1));
            return (long)hours * 3600000L;
        }
        if (offsetStr.endsWith("m")) {
            int minutes = Integer.parseInt(offsetStr.substring(0, offsetStr.length() - 1));
            return (long)minutes * 60000L;
        }
        if (offsetStr.endsWith("s")) {
            int seconds = Integer.parseInt(offsetStr.substring(0, offsetStr.length() - 1));
            return (long)seconds * 1000L;
        }
        int hours = Integer.parseInt(offsetStr);
        return (long)hours * 3600000L;
    }
}

