/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag.next;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.nwdiag.core.NServer;
import net.sourceforge.plantuml.nwdiag.core.NwGroup;
import net.sourceforge.plantuml.nwdiag.next.NBar;
import net.sourceforge.plantuml.nwdiag.next.NBox;
import net.sourceforge.plantuml.nwdiag.next.NStage;
import net.sourceforge.plantuml.nwdiag.next.NTetris;

public class NPlayField {
    private final List<NStage> stages = new ArrayList<NStage>();
    private final List<NBox> boxes = new ArrayList<NBox>();

    public NStage getStage(int num) {
        while (this.stages.size() <= num) {
            this.stages.add(new NStage(this.stages.size()));
        }
        return this.stages.get(num);
    }

    public NStage getLast() {
        if (this.stages.size() == 0) {
            return null;
        }
        return this.getStage(this.stages.size() - 1);
    }

    public NStage createNewStage() {
        return this.getStage(this.stages.size());
    }

    public void addInPlayfield(NBar bar) {
        if (bar.getParent() == null) {
            NBox single = new NBox();
            single.add(bar);
            bar.setParent(single);
            this.boxes.add(bar.getParent());
        } else if (!this.boxes.contains(bar.getParent())) {
            this.boxes.add(bar.getParent());
        }
    }

    public Map<NBar, Integer> doLayout() {
        NTetris<NBox> tetris = new NTetris<NBox>();
        for (NBox box : this.boxes) {
            tetris.add(box);
        }
        HashMap<NBar, Integer> result = new HashMap<NBar, Integer>();
        Map pos = tetris.getPositions();
        for (Map.Entry ent : pos.entrySet()) {
            NBox box = (NBox)ent.getKey();
            int boxPos = ent.getValue();
            Map<NBar, Integer> bars = box.getPositions();
            for (Map.Entry<NBar, Integer> bar : bars.entrySet()) {
                result.put(bar.getKey(), boxPos + bar.getValue());
            }
        }
        return Collections.unmodifiableMap(result);
    }

    public void fixGroups(List<NwGroup> groups, Collection<NServer> servers) {
        for (NwGroup group : groups) {
            for (NServer server : servers) {
                if (!group.contains(server)) continue;
                this.fixServerInGroup(server, group);
            }
        }
    }

    private void fixServerInGroup(NServer server, NwGroup group) {
        NBox groupBox = group.getNboxInternal();
        if (server.getBar().getParent() == groupBox) {
            return;
        }
        this.boxes.remove(server.getBar().getParent());
        if (!this.boxes.contains(groupBox)) {
            this.boxes.add(groupBox);
        }
        server.getBar().setParent(groupBox);
        groupBox.add(server.getBar());
    }
}

