module completions {

  def "nu-complete satty fullscreen" [] {
    [ "all" "current-screen" ]
  }

  def "nu-complete satty initial_tool" [] {
    [ "pointer" "crop" "line" "arrow" "rectangle" "ellipse" "text" "marker" "blur" "highlight" "brush" ]
  }

  def "nu-complete satty actions_on_enter" [] {
    [ "save-to-clipboard" "save-to-file" "save-to-file-as" "copy-filepath-to-clipboard" "exit" ]
  }

  def "nu-complete satty actions_on_escape" [] {
    [ "save-to-clipboard" "save-to-file" "save-to-file-as" "copy-filepath-to-clipboard" "exit" ]
  }

  def "nu-complete satty actions_on_right_click" [] {
    [ "save-to-clipboard" "save-to-file" "save-to-file-as" "copy-filepath-to-clipboard" "exit" ]
  }

  def "nu-complete satty primary_highlighter" [] {
    [ "block" "freehand" ]
  }

  def "nu-complete satty action_on_enter" [] {
    [ "save-to-clipboard" "save-to-file" "save-to-file-as" "copy-filepath-to-clipboard" "exit" ]
  }

  # Modern Screenshot Annotation.
  export extern satty [
    --config(-c): string      # Path to the config file. Otherwise will be read from XDG_CONFIG_DIR/satty/config.toml
    --filename(-f): string    # Path to input image or '-' to read from stdin
    --fullscreen: string@"nu-complete satty fullscreen" # Start Satty in fullscreen mode. Since 0.20.1, takes optional parameter. --fullscreen without parameter is equivalent to --fullscreen current. Mileage may vary depending on compositor
    --resize: string          # Resize to coordinates or use smart mode (0.20.1). --resize without parameter is equivalent to --resize smart [possible values: smart, WxH.]
    --floating-hack           # Try to enforce floating (0.20.1). Mileage may vary depending on compositor
    --output-filename(-o): string # Filename to use for saving action or '-' to print to stdout. Omit to disable saving to file. Might contain format specifiers: <https://docs.rs/chrono/latest/chrono/format/strftime/index.html>. Since 0.20.0, can contain tilde (~) for home dir
    --early-exit              # Exit directly after copy/save action. 0.20.1: This does not apply to "save as"
    --early-exit-save-as      # Experimental (0.20.1): Exit directly after save as
    --corner-roundness: string # Draw corners of rectangles round if the value is greater than 0 (Defaults to 12) (0 disables rounded corners)
    --initial-tool: string@"nu-complete satty initial_tool" # Select the tool on startup
    --init-tool: string@"nu-complete satty initial_tool" # Select the tool on startup
    --copy-command: string    # Configure the command to be called on copy, for example `wl-copy`
    --annotation-size-factor: string # Increase or decrease the size of the annotations
    --save-after-copy         # After copying the screenshot, save it to a file as well Preferably use the `action_on_copy` option instead
    --actions-on-enter: string@"nu-complete satty actions_on_enter" # Actions to perform when pressing Enter
    --actions-on-escape: string@"nu-complete satty actions_on_escape" # Actions to perform when pressing Escape
    --actions-on-right-click: string@"nu-complete satty actions_on_right_click" # Actions to perform when hitting the copy Button
    --default-hide-toolbars(-d) # Hide toolbars by default
    --focus-toggles-toolbars  # Experimental (since 0.20.0): Whether to toggle toolbars based on focus. Doesn't affect initial state
    --default-fill-shapes     # Experimental feature (since 0.20.0): Fill shapes by default
    --font-family: string     # Font family to use for text annotations
    --font-style: string      # Font style to use for text annotations
    --primary-highlighter: string@"nu-complete satty primary_highlighter" # The primary highlighter to use, secondary is accessible with CTRL
    --disable-notifications   # Disable notifications
    --profile-startup         # Print profiling
    --no-window-decoration    # Disable the window decoration (title bar, borders, etc.) Please note that the compositor has the final say in this. Requires xdg-decoration-unstable-v1
    --brush-smooth-history-size: string # Experimental feature: How many points to use for the brush smoothing algorithm. 0 disables smoothing. The default value is 0 (disabled)
    --zoom-factor: string     # Experimental feature (0.20.1): The zoom factor to use for the image. 1.0 means no zoom. defaults to 1.1
    --pan-step-size: string   # Experimental feature (0.20.1): The pan step size to use when panning with arrow keys. defaults to 50.0
    --text-move-length: string # Experimental feature (0.20.1): The length to move the text when using the arrow keys. defaults to 50.0
    --input-scale: string     # Experimental feature (0.20.1): Scale the default window size to fit different displays. Note that this is ignored with explicit resize
    --right-click-copy        # Right click to copy. Preferably use the `action_on_right_click` option instead
    --action-on-enter: string@"nu-complete satty action_on_enter" # Action to perform when pressing Enter. Preferably use the `actions_on_enter` option instead
    --help(-h)                # Print help
    --version(-V)             # Print version
  ]

}

export use completions *
