/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.SkipResult;

public class Authorization {
    private static final Map<String, FieldType> fieldTypes = new HashMap<String, FieldType>();

    private Authorization() {
    }

    public static Map<String, String> parseAuthorizationDigest(StringReader stringReader) throws IllegalArgumentException, IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (HttpParser.skipConstant(stringReader, "Digest") != SkipResult.FOUND) {
            return null;
        }
        String string = HttpParser.readToken(stringReader);
        if (string == null) {
            return null;
        }
        while (!string.isEmpty()) {
            if (HttpParser.skipConstant(stringReader, "=") != SkipResult.FOUND) {
                return null;
            }
            FieldType fieldType = fieldTypes.get(string.toLowerCase(Locale.ENGLISH));
            if (fieldType == null) {
                fieldType = FieldType.TOKEN_OR_QUOTED_STRING;
            }
            String string2 = null;
            switch (fieldType) {
                case QUOTED_STRING: {
                    string2 = HttpParser.readQuotedString(stringReader, false);
                    break;
                }
                case TOKEN_OR_QUOTED_STRING: {
                    string2 = HttpParser.readTokenOrQuotedString(stringReader, false);
                    break;
                }
                case LHEX: {
                    string2 = HttpParser.readLhex(stringReader);
                    break;
                }
                case QUOTED_TOKEN: {
                    string2 = HttpParser.readQuotedToken(stringReader);
                }
            }
            if (string2 == null) {
                return null;
            }
            hashMap.put(string, string2);
            if (HttpParser.skipConstant(stringReader, ",") == SkipResult.NOT_FOUND) {
                return null;
            }
            string = HttpParser.readToken(stringReader);
            if (string != null) continue;
            return null;
        }
        return hashMap;
    }

    static {
        fieldTypes.put("username", FieldType.QUOTED_STRING);
        fieldTypes.put("realm", FieldType.QUOTED_STRING);
        fieldTypes.put("nonce", FieldType.QUOTED_STRING);
        fieldTypes.put("digest-uri", FieldType.QUOTED_STRING);
        fieldTypes.put("response", FieldType.LHEX);
        fieldTypes.put("algorithm", FieldType.QUOTED_TOKEN);
        fieldTypes.put("cnonce", FieldType.QUOTED_STRING);
        fieldTypes.put("opaque", FieldType.QUOTED_STRING);
        fieldTypes.put("qop", FieldType.QUOTED_TOKEN);
        fieldTypes.put("nc", FieldType.LHEX);
    }

    private static enum FieldType {
        QUOTED_STRING,
        TOKEN_OR_QUOTED_STRING,
        LHEX,
        QUOTED_TOKEN;

    }
}

