/*
 * Copyright (C) 2023 Igalia S.L.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WPEVersion_h
#define WPEVersion_h

#if !defined(__WPE_PLATFORM_H_INSIDE__) && !defined(BUILDING_WEBKIT)
#error "Only <wpe/wpe-platform.h> can be included directly."
#endif

#include <wpe/WPEDefines.h>

G_BEGIN_DECLS

/**
 * WPE_PLATFORM_MAJOR_VERSION:
 *
 * Like wpe_platform_get_major_version(), but from the headers used at
 * application compile time, rather than from the library linked
 * against at application run time.
 */
#define WPE_PLATFORM_MAJOR_VERSION (2)

/**
 * WPE_PLATFORM_MINOR_VERSION:
 *
 * Like wpe_platform_get_minor_version(), but from the headers used at
 * application compile time, rather than from the library linked
 * against at application run time.
 */
#define WPE_PLATFORM_MINOR_VERSION (50)

/**
 * WPE_PLATFORM_MICRO_VERSION:
 *
 * Like wpe_platform_get_micro_version(), but from the headers used at
 * application compile time, rather than from the library linked
 * against at application run time.
 */
#define WPE_PLATFORM_MICRO_VERSION (4)

/**
 * WPE_PLATFORM_CHECK_VERSION:
 * @major: major version (e.g. 1 for version 1.2.5)
 * @minor: minor version (e.g. 2 for version 1.2.5)
 * @micro: micro version (e.g. 5 for version 1.2.5)
 *
 * Check the version of WPE platform header files at compile time.
 *
 * Returns: %TRUE if the version of the WPE platform header files
 * is the same as or newer than the passed-in version.
 */
#define WPE_PLATFORM_CHECK_VERSION(major, minor, micro) \
    (WPE_PLATFORM_MAJOR_VERSION > (major) || \
    (WPE_PLATFORM_MAJOR_VERSION == (major) && WPE_PLATFORM_MINOR_VERSION > (minor)) || \
    (WPE_PLATFORM_MAJOR_VERSION == (major) && WPE_PLATFORM_MINOR_VERSION == (minor) && \
     WPE_PLATFORM_MICRO_VERSION >= (micro)))

WPE_API guint
wpe_platform_get_major_version (void);

WPE_API guint
wpe_platform_get_minor_version (void);

WPE_API guint
wpe_platform_get_micro_version (void);

G_END_DECLS

#endif /* WPEVersion_h */
